/*
 *  Polak-Riviere conjugate gradient nonlinear optimization
 *  Purpose:  Nonlinear optimization module
 *  Date: Oct 10, 2012
 *  Author: Thomas Robey
 *  Input:  
 *    r:  dimension of system
 *    x:  vector of dimension r containing the initial guess
 *  Output:
 *    x:  vector containing optimized parameters
 *  Subroutines:
 *    cubsrch
 *    fandg
 */
#include "math.h"
#include "stdio.h"
#include "float.h"
int main(argc,argv)
int argc;
char *argv[];
{
  unsigned maxiter;
  double resid,nlfn;
  double alpha,f,t1,t2,t3,beta,dtg;
  double x[2],g[2],d[2],gg[2],gold[2],y[2],dold[2],xold[2];
  int i,j,k,n,numiter,r;
  int cubsrch(int,double *,double *,double *,double *,double,double,double,
    double *,double,int,int *);
  double fandg(double *,double *);
  r=2;
  resid = 1.0e-6;
  x[0] = 5.0;
  x[1] = 7.0;
  maxiter=100;
  numiter=0;
  n=0;
  for (i=0;i<r;i++) {
    gold[i]=0.0;
    dold[i]=0.0;
  }
  f=fandg(x,g);
  printf("%d: f(",numiter);
  for (j=0;j<r-1;j++)
    printf("%.15f,",x[j]);
  printf("%.15f)=%.15f\n",x[r-1],f);
  while (1) {
    for (i=0;i<r;i++)
      d[i]=-g[i];
    for (k=0;k<r;k++) {
      dtg=0.0;
      t1=0.0;
      t2=0.0;
      for (i=0;i<r;i++) {
        dtg+=d[i]*g[i];
        gg[i]=g[i];
        t1+=dold[i]*gold[i];
        t2+=d[i]*g[i];
      }
      if (n==0)
        alpha=1.0;
      else
        alpha*=t1/t2;
      j=n;
      for (i=0;i<r;i++)
        xold[i]=x[i];
      i=cubsrch(r,x,&f,gg,d,1.0e-4,0.9,DBL_EPSILON,&alpha,dtg,25,&n);
      numiter++;
      printf("%d: f(",numiter);
      for (j=0;j<r-1;j++)
        printf("%.15f,",x[j]);
      printf("%.15f)=%.15f\n",x[r-1],f);
      if (i<0) {
        for (j=0;j<r;j++)
          x[j]=xold[j];
        printf("Error %d\n",-i);
        return(i);
      }
      for (i=0;i<r;i++) {
        gold[i]=g[i];
        dold[i]=d[i];
      }
      nlfn=fandg(x,g);
      t1=0.0;
      for (i=0;i<r;i++)
        t1+=g[i]*g[i];
      if (t1<resid*resid || numiter>=maxiter) {
        printf("gradient residual = %lg\n",sqrt(t1));
        printf("Gradient is (");
        for (j=0;j<r-1;j++)
          printf("%17.10e,",g[j]);
        printf("%17.10e)\n\n",g[r-1]);
        return(0);
      }
      f=nlfn;
      for (i=0;i<r;i++)
        y[i]=g[i]-gold[i];
      t1=0.0;
      t2=0.0;
      for (i=0;i<r;i++) {
        t1+=g[i]*y[i];
        t2+=gold[i]*gold[i];
      }
      beta=t1/t2;
      for (i=0;i<r;i++)
        d[i]=-g[i]+beta*d[i];
      t1=0.0;
      t2=0.0;
      t3=0.0;
      for (i=0;i<r;i++) {
        t1+=g[i]*gold[i];
        t2+=g[i]*g[i];
        t3+=d[i]*g[i];
      }
      t1=(t1<0.0) ? -t1 : t1;
      if (t1>=0.2*t2 || t3>=-0.8*t2)
        break;
    }
  }
}

